﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.HR" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<script runat="server">

    public class Params: ContextBase {
        public Params(Context context): base(context) {
            stanNaDzien = ((ActualDate)context[typeof(ActualDate)]).Actual;
        }

        DefinicjaUprawnienia[] definicja;
        [Priority(10)]
        [Caption("Definicja")]
        public DefinicjaUprawnienia[] Definicja {
            get { return definicja; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicja() {
            HRModule hr = HRModule.GetInstance(this);
            Soneta.Business.View v = hr.DefUprawnien.WgNazwy.CreateView();
            v.Condition &= new FieldCondition.Equal("Blokada", false);
            v.Condition &= new FieldCondition.Equal("Bezterminowe", false);
            return v;
        }

        Date stanNaDzien;
        [Required]
        [Priority(20)]
        [Caption("Stan na dzień")]
        public Date StanNaDzien {
            get { return stanNaDzien; }
            set {
                stanNaDzien = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool utracone = false;
        [Priority(30)]
        [Caption("Tylko utracone")]
        public bool Utracone {
            get { return utracone; }
            set {
                utracone = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    [Context]
    public Params Param {
        set {
            definicja = value.Definicja;
            stanNaDzien = value.StanNaDzien;
            utracone = value.Utracone;    
        }
    }

    RowCondition condition = RowCondition.Empty;
    DefinicjaUprawnienia[] definicja;
    Date stanNaDzien;
    bool utracone;
    
    void OnContextLoad(Object sender, EventArgs args) {
        ReportHeader1["DEFINICJA"] = Info("Definicja", "Definicje", (definicja != null) ? definicja : new object[] { "(wszystkie)" });
        ReportHeader1["DATA"] = stanNaDzien.ToString();
        if (definicja != null && definicja.Length > 0)
            condition &= new FieldCondition.In("Definicja", definicja);
    }

    protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
        Pracownik prac = (Pracownik)args.Row;
        SubTable st = prac.Uprawnienia;
        st = st[condition];

        Date data;
        bool any = false;
        if (!utracone) {
            colKod.AddLine(prac.Kod);
            colNazwisko.AddLine(prac.Nazwisko + " " + prac.Imie);
            any = true;
        }
        foreach (UprawnieniePracownika up in st) {
            data = up.DataUtraty != Date.MaxValue ? up.DataUtraty.AddDays(-1) : up.TerminWaznosci;
            if (stanNaDzien <= data)
                continue;
            if (!any) {
                colKod.AddLine(prac.Kod);
                colNazwisko.AddLine(prac.Nazwisko + " " + prac.Imie);
            }
            colUprawnienie.AddLine(up.Definicja);
            colData.AddLine(data);
            any = true;
        }
        args.VisibleRow = any;
    }

    static string Info(string singleLabel, string multiLabel, params object[] lst) {
        if (lst == null || lst.Length == 0)
            return "";
        else if (lst.Length == 1)
            return string.Format("</strong>|{0}: <strong>{1}", singleLabel, lst[0]);
        string info = "";
        foreach (object obj in lst)
            if (info == "")
                info = obj.ToString();
            else
                info += "</strong>, <strong>" + obj.ToString();
        return string.Format("</strong>|{0}: <strong>{1}", multiLabel, info);
    }

</script>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Badania okresowe</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="BadaniaOkresowe" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Uprawnienia - braki|%DEFINICJA%|</strong>Stan na dzień:<strong> %DATA%"
            runat="server"></cc1:ReportHeader>
        <ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" VAlign="Middle" DataMember="#" Caption="Lp."></ea:GridColumn>
                <ea:GridColumn Width="20" Align="Left" VAlign="Middle" ID="colKod" Caption="Kod"></ea:GridColumn>
                <ea:GridColumn Align="Left" VAlign="Middle" Caption="Nazwisko i imię" ID="colNazwisko"></ea:GridColumn>
                <ea:GridColumn Width="30" Align="Left" VAlign="Top" Caption="Uprawnienie" ID="colUprawnienie"></ea:GridColumn>
                <ea:GridColumn Width="12" Align="Left" VAlign="Top" Caption="Data ważności" ID="colData"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
    </form>
</body>
</html>
